#include "start_stop.h"

void start_stop_init (void)
{
    LPC_SCT->MATCH[0].L     = counterL_stop;               // deactivate_L
    LPC_SCT->MATCHREL[0].L  = counterL_stop;
    LPC_SCT->MATCH[0].H     = counterL_start;              // activate_L
    LPC_SCT->MATCHREL[0].H  = counterL_start;
    LPC_SCT->MATCH[1].L     = counterH_start;              // activate_H
    LPC_SCT->MATCHREL[1].L  = counterH_start;
    LPC_SCT->MATCH[1].H     = counterH_stop;               // deactivate_H
    LPC_SCT->MATCHREL[1].H  = counterH_stop;

    LPC_SCT->EVENT[0].STATE = (1 << 1);                    // event 0 happens in state 1
    LPC_SCT->EVENT[0].CTRL  = (0 << 0)  |                  // MATCHSEL [3:0]   = related to match 0
                              (0 << 4)  |                  // HEVENT   [4]     = use L state & match
                              (1 << 12) |                  // COMBMODE [13:12] = match AND IO condition
                              (1 << 14) |                  // STATELD  [14]    = STATEV is loaded into state
                              (0 << 15);                   // STATEV   [19:15] = new state is 0

    LPC_SCT->EVENT[1].STATE = (1 << 0);                    // event 1 happens in state 0
    LPC_SCT->EVENT[1].CTRL  = (0 << 0)  |                  // MATCHSEL [3:0]   = related to match 0
                              (1 << 4)  |                  // HEVENT   [4]     = use H state & match
                              (1 << 12) |                  // COMBMODE [13:12] = match AND IO condition
                              (1 << 14) |                  // STATELD  [14]    = STATEV is loaded into state
                              (1 << 15);                   // STATEV   [19:15] = new state is 1

    LPC_SCT->EVENT[2].STATE = (1 << 0);                    // event 2 happens in state 0
    LPC_SCT->EVENT[2].CTRL  = (1 << 0)  |                  // MATCHSEL [3:0]   = related to match 1
                              (0 << 4)  |                  // HEVENT   [4]     = use L state & match
                              (1 << 12) |                  // COMBMODE [13:12] = match AND IO condition
                              (1 << 14) |                  // STATELD  [14]    = STATEV is loaded into state
                              (1 << 15);                   // STATEV   [19:15] = new state is 1

    LPC_SCT->EVENT[3].STATE = (1 << 1);                    // event 3 happens in state 1
    LPC_SCT->EVENT[3].CTRL  = (1 << 0)  |                  // MATCHSEL [3:0]   = related to match 1
                              (1 << 4)  |                  // HEVENT   [4]     = use H state & match
                              (1 << 12) |                  // COMBMODE [13:12] = match AND IO condition
                              (1 << 14) |                  // STATELD  [14]    = STATEV is loaded into state
                              (0 << 15);                   // STATEV   [19:15] = new state is 0

    LPC_SCT->OUT[0].SET     = (1 << 1) | (1 << 3);         // event 1 and 3 set OUT0   -> counter L RUN
    LPC_SCT->OUT[0].CLR     = (1 << 0) | (1 << 2);         // event 0 and 2 clear OUT0
    LPC_SCT->OUT[1].SET     = (1 << 0) | (1 << 2);         // event 0 and 2 set OUT1   -> counter H RUN
    LPC_SCT->OUT[1].CLR     = (1 << 1) | (1 << 3);         // event 1 and 3 clear OUT1
    LPC_SCT->OUT[2].SET     = (1 << 2);                    // event 2 will set OUT2    -> STATE 1
    LPC_SCT->OUT[2].CLR     = (1 << 0);                    // event 0 will clear OUT2
    LPC_SCT->OUT[3].SET     = (1 << 1);                    // event 1 will set OUT3    -> STATE 2
    LPC_SCT->OUT[3].CLR     = (1 << 3);                    // event 3 will clear OUT3
    LPC_SCT->OUTPUT         = (1 << 0);                    // OUT0 high OUT1/2/3 low

    LPC_SCT->STOP_L         = (1 << 0) | (1 << 2);         // events 0 and 2 STOP the L counter
    LPC_SCT->START_L        = (1 << 1) | (1 << 3);         // events 1 and 3 START the L counter
    LPC_SCT->LIMIT_L        = (1 << 0) | (1 << 2);         // events 0 and 2 as L counter limit

    LPC_SCT->STOP_H         = (1 << 1) | (1 << 3);         // events 1 and 3 STOP the H counter
    LPC_SCT->START_H        = (1 << 0) | (1 << 2);         // events 0 and 2 START the H counter
    LPC_SCT->LIMIT_H        = (1 << 1) | (1 << 3);         // events 1 and 3 as H counter limit

    LPC_SCT->CTRL_U         = (0  << 0)  |                 // DOWN_L [0]     = L counting down
                              (0  << 1)  |                 // STOP_L [1]     = L counter does run
                              (0  << 2)  |                 // HALT_L [2]     = unhalt the L counter
                              (1  << 3)  |                 // CLRT_L [3]     = clear L counter
                              (0  << 4)  |                 // BIDIR_L[4]     = not bidirectional counting
                              (11 << 5)  |                 // PRE_L  [12:5]  = L prescaler = 12
                              (0  << 16) |                 // DOWN_H [16]    = H counting down
                              (1  << 17) |                 // STOP_H [1]     = stop the H counter
                              (0  << 18) |                 // HALT_H [2]     = unhalt the H counter
                              (1  << 19) |                 // CLRT_H [3]     = clear H counter
                              (0  << 20) |                 // BIDIR_H[4]     = not bidirectional counting
                              (11 << 21);                  // PRE_H  [28:21] = H prescaler = 12
}
